-- HAM
-- Simulate the H.A.M. (Hold And Modify)
-- mode of the Amiga's Days!



-- some functions...


-- Determine the greater value of 3
function max_p(x1, x2, x3)
local v
if x1 > x2 then
 if x1 > x3 then
  v = 1
 else
  v = 3
 end
 else 
  if x2 > x3 then
  v = 2
 else
  v = 3
 end
end
return v
end

-- Quantize each component in 4bit range
function quantize(x)
 x = math.floor(x/16) * 16
 return x
end 



-- begin main program...


GUI_SetCaption("Ham")

GUI_AddLogo("HamLogo.bmp")

--setup a combo box
h1 = GUI_AddControl("Combobox", "Dithering")
--set the list in the combo box
GUI_SetList (h1,0,"Floyed")
GUI_SetList (h1,1,"Halftone")
GUI_SetList (h1,2,"Random")
GUI_SetList (h1,3,"None")

--set the current string in the combo box
GUI_SetSettings (h1,0, "Floyed")



GUI_OpenPanel()


repeat
idx, retval, retstr = GUI_WaitOnEvent()
until idx < 0


-- if OK was pressed.

if (idx==-1) then


h1_value, h1_string = GUI_GetSettings (h1)


--dither the image using and existing plugin


if h1_string =="Floyed" then
Dog_ShellExe("12_bit_dither_pf.exe")
Dog_GetBuffer()
end

if h1_string =="Halftone" then
Dog_ShellExe("12_bit_halftone_pf.exe")
Dog_GetBuffer()
end

if h1_string =="Random" then
Dog_ShellExe("12_bit_random_pf.exe")
Dog_GetBuffer()
end


for y = bound_y0, bound_y1 do
-- Start with black at every scanline
lr = 0
lg = 0
lb = 0
for x = bound_x0, bound_x1 do
r, g, b = get_rgb(x, y)
r=r*255
g=g*255
b=b*255
r = quantize(r)
g = quantize(g)
b = quantize(b)
r=r/255
g=g/255
b=b/255
-- Calculate the difference with last pixel
dr = math.abs(r - lr)
dg = math.abs(g - lg)
db = math.abs(b - lb)
-- Change only the most different component
v = max_p(dr, dg, db)
if v == 1 then
lr = r
elseif v == 2 then
lg = g
else
lb = b
end
set_rgb(x, y, lr, lg, lb) 
end
progress((y - bound_y0) / (bound_y1-bound_y0))
end

end 



GUI_ClosePanel()
